#include    <iostream>
#include    <algorithm>
using namespace std;

long long   x[1000000],
            h[1000000], 
            indeksi[1000000];
int n;

long long udaljenost(int i)
{
    int id = indeksi[i];
    long long x0 = x[id];
    long long h0 = h[id];
    long long najblizi = -1;

    if (i > 0)
    {
        int lid = indeksi[i - 1];
        long long xl = x[lid];
        long long hl = h[lid];
        long long udalj = -1;

        if (hl >= h0)
        {
            udalj = x0 - (xl + (hl - h0));
        }
        else
        {
            long long p = (x0 - xl + h0 + hl) / 2;
            if (p >= xl && p <= x0)
            {
                long long visina = hl - (p - xl);
                if (visina >= h0)
                {
                    udalj = x0 - p;
                }
            }
        }

        if (udalj != -1)
        {
            najblizi = udalj;
        }
    }

    if (i < n - 1)
    {
        int rid = indeksi[i + 1];
        long long xr = x[rid];
        long long hr = h[rid];
        long long udalj = -1;

        if (hr >= h0)
        {
            udalj = (xr - (hr - h0)) - x0;
        }
        else
        {
            long long p = (xr - x0 + h0 + hr) / 2;
            if (p >= x0 && p <= xr)
            {
                long long visina = hr - (xr - p);
                if (visina >= h0)
                {
                    udalj = p - x0;
                }
            }
        }

        if (udalj != -1)
        {
            if (najblizi == -1 || udalj < najblizi)
            {
                najblizi = udalj;
            }
        }
    }

    return najblizi;
}

int main()
{
    cin >> n;

    for (int i = 0; i < n; i++)
    {
        cin >> x[i];
    }

    for (int i = 0; i < n; i++)
    {
        cin >> h[i];
    }

    for (int i = 0; i < n; i++)
    {
        indeksi[i] = i;
    }

    sort(indeksi, indeksi + n, [](int a, int b) {
        return x[a] < x[b]; 
    });

    for (int i = 0; i < n; i++)
    {
        cout << udaljenost(i) << "\n";
    }

    return 0;
}